<?php
// カスタムメニューを使用する ---------------------------------------------------------------------------
add_theme_support('menus');
register_nav_menu('globalNavi', 'グローバルナビ');
register_nav_menu('globalNavi_sp', 'グローバルナビSP');
register_nav_menu('globalNavi_en', 'グローバルナビ（英）');
register_nav_menu('globalNavi_sp_en', 'グローバルナビSP（英）');
register_nav_menu('footerMenu_1', 'フッターメニュー１');
register_nav_menu('footerMenu_2', 'フッターメニュー２');
register_nav_menu('footerMenu_3', 'フッターメニュー３');
register_nav_menu('footerMenu_4', 'フッターメニュー４');
register_nav_menu('footerMenu_1_en', 'フッターメニュー１（英）');
register_nav_menu('footerMenu_2_en', 'フッターメニュー２（英）');
register_nav_menu('footerMenu_3_en', 'フッターメニュー３（英）');
register_nav_menu('footerMenu_4_en', 'フッターメニュー４（英）');

// 画像URL簡略化
function imagepassshort($arg) {
  $content = str_replace('"images/', '"' . get_bloginfo('template_directory') . '/images/', $arg);
  return $content;
}
add_action('the_content', 'imagepassshort');

// サムネイル -------------------------------------------------------------------------------------------
add_theme_support( 'post-thumbnails' );

//カスタムメニュー説明表示
function prefix_nav_description( $item_output, $item, $depth, $args ) {
	if ( !empty( $item->description ) ) {
	$item_output = str_replace( '">' . $args->link_before . $item->title, '">' . $args->link_before . '<strong>' . $item->title . '</strong>' . '<span class="menu-item-description">' . $item->description . '</span>' , $item_output );
	}
	return $item_output;
 }
 add_filter('walker_nav_menu_start_el', 'prefix_nav_description', 10, 4);
 
// 記事スライダー -------------------------------------------------------------------------------------------
function slider_scripts(){
	wp_enqueue_script('slider', get_template_directory_uri() .'/js/bundle.js', array('jquery') );
	}
	add_action( 'wp_enqueue_scripts' , 'slider_scripts' );

// カスタム投稿タイプ「ニュース」を追加する
function create_post_type_news() {
  $Supports = [
    'title',
    'editor',
    'thumbnail',
  ];
  register_post_type('news',
    array(
      'label' => 'ニュース',
      'labels' => array(
      'all_items' => 'ニュース一覧'
      ),
      'public' => true,
      'has_archive' => true,
      'menu_position' => 5,
      'supports' => $Supports
    )
  );
}
add_action('init', 'create_post_type_news');

// bodyタグにclassを追加 --------------------------------------------------------------------------------
function ml_body_classes($classes) {
    global $wp_query, $post;

	/* スラッグを挿入 */
    if (is_page() && !is_front_page() ) { //slugを追加
      $page = get_page(get_the_ID());
      $classes[] = "page-" . $page->post_name;
    } elseif (is_category() || is_single()) { //slugを追加
      $category = get_the_category();
      $classes[] = "page-" . $category[0]->slug;
    }
    return array_unique($classes);
};
add_filter('body_class','ml_body_classes');

// グローバルメニューカスタマイズ-------------------------------------------------------------------------
add_filter('walker_nav_menu_start_el', 'description_in_nav_menu', 10, 4);
 
function description_in_nav_menu($item_output, $item){
	if($item->attr_title){
		return preg_replace('/(<a.*?>[^<]*?)</', '$1' . "<br /><span>{$item->attr_title}</span><", $item_output);
	} else {
		return preg_replace('/(<a.*?>[^<]*?)</', '$1' . "<", $item_output);
	}
}

function getPageLink($attr) {
	return get_page_link($attr[0]);
}
add_shortcode('pageLink', 'getPageLink');

function getCategoryLink($attr) {
	return get_category_link($attr[0]);
}
add_shortcode('categoryLink', 'getCategoryLink');

function getHomeLink() {
	return get_bloginfo('url');
}
add_shortcode('homeLink', 'getHomeLink');

function shortcode_templateurl() {
  return get_bloginfo('template_url');
}
add_shortcode('t_url', 'shortcode_templateurl');

// 固定ページでビジュアルエディタを非表示
function disable_visual_editor_in_page(){
	global $typenow;
	if( $typenow == 'page' ){
		add_filter('user_can_richedit', 'disable_visual_editor_filter');
	}
}
function disable_visual_editor_filter(){
	return false;
}
add_action( 'load-post.php', 'disable_visual_editor_in_page' );
add_action( 'load-post-new.php', 'disable_visual_editor_in_page' );


// カテゴリー選択をラジオボタンに
function my_print_footer_scripts() {
echo '<script type="text/javascript">
//<![CDATA[
jQuery(document).ready(function($){
// 投稿画面のカテゴリー選択を制限
$(".categorychecklist input[type=checkbox]").each(function(){
$(this).replaceWith($(this).clone().attr("type","radio"));
});
// クイック編集のカテゴリー選択を制限
$(".cat-checklist input[type=checkbox]").each(function(){
$(this).replaceWith($(this).clone().attr("type","radio"));
});
});
//]]>
</script>';
}
add_action('admin_print_footer_scripts', 'my_print_footer_scripts', 21);

// 管理画面にオリジナルのスタイルを適用
add_editor_style("style.css");
add_editor_style('css/editor-style.css');

// Hooks your functions into the correct filters
function my_add_mce_button() {
	// check user permissions
	if ( !current_user_can( 'edit_posts' ) && !current_user_can( 'edit_pages' ) ) {
		return;
	}
	// check if WYSIWYG is enabled
	if ( 'true' == get_user_option( 'rich_editing' ) ) {
		add_filter( 'mce_external_plugins', 'my_add_tinymce_plugin' );
		add_filter( 'mce_buttons', 'my_register_mce_button' );
	}
}
add_action('admin_head', 'my_add_mce_button');

// Declare script for new button
function my_add_tinymce_plugin( $plugin_array ) {
	$plugin_array['my_mce_button'] = get_template_directory_uri() .'/js/mce-button.js';
	return $plugin_array;
}

// Register new button in the editor
function my_register_mce_button( $buttons ) {
	array_push( $buttons, 'my_mce_button' );
	return $buttons;
}


function appthemes_add_quicktags() {
  if (wp_script_is('quicktags')){
?>
<script type="text/javascript">
  QTags.addButton('section_image', 'セクションヘッダ画像', '<img class="section_image" src="ここに表示させたい画像URL" alt="" />' + '\n' + '\n', '');
  QTags.addButton('h2', 'H2見出し', '<h2>H2見出し</h2>' + '\n' + '\n', '');
  QTags.addButton('h3', 'H3見出し', '<h3>H3見出し</h3>' + '\n' + '\n', '');
  QTags.addButton('h4', 'H4見出し', '<h4>H4見出し</h4>' + '\n' + '\n', '');
  QTags.addButton('h5', 'H5見出し', '<h5>H5見出し</h5>' + '\n' + '\n', '');
  QTags.addButton('hr', '区切り線', '<hr>' + '\n' + '\n', '');
  QTags.addButton('read', 'テキスト（強調）', '<p class="read">任意のテキスト</p>' + '\n' + '\n', '');
  QTags.addButton('text', 'テキスト（標準）', '<p class="text">任意のテキスト</p>' + '\n' + '\n', '');
  QTags.addButton('note', 'テキスト（補足）', '<p class="note">任意のテキスト</p>' + '\n' + '\n', '');
  QTags.addButton('strong', '装飾（強調）', '<strong>任意のテキスト</strong>' + '\n' + '\n', '');
  QTags.addButton('list', 'リスト', '<ul class="list"><li>任意のテキスト</li><li>任意のテキスト</li><li>任意のテキスト</li></ul>' + '\n' + '\n', '');
  QTags.addButton('tbl', 'テーブル（標準）', '<table class="tbl"><thead><tr><th>ヘッダ</th><th>ヘッダ</th></tr></thead><tbody><tr><td>データ</td><td>データ</td></tr></tbody></table>' + '\n' + '\n', '');
  QTags.addButton('wrap_tbl', 'テーブル（スクロール）', '<div class="wrap_tbl"><table class="tbl"><thead><tr><th>ヘッダ</th><th>ヘッダ</th></tr></thead><tbody><tr><td>データ</td><td>データ</td></tr></tbody></table></div>' + '\n' + '\n', '');
  QTags.addButton('special_btn', 'ボタン（特別）', '<a class="special_btn" href="#">ボタン（特別）</a>' + '\n' + '\n', '');
  QTags.addButton('btn', 'ボタン（標準）', '<a class="btn" href="#">ボタン（標準）</a>' + '\n' + '\n', '');
  QTags.addButton('btn_arrow', 'ボタン（矢印つき）', '<a class="btn btn_arrow" href="#">ボタン（矢印つき）</a>' + '\n' + '\n', '');
  QTags.addButton('wrap_btn', 'ボタン（リスト）', '<ul class="wrap_btn"><li><a class="btn" href="#">ボタン</a></li><li><a class="btn" href="#">ボタン</a></li></ul>' + '\n' + '\n', '');
  QTags.addButton('image_text', '画像つきテキスト', '<div class="wrap"><img class="image" src="ここに表示させたい画像URL" alt="" /><div class="text">任意のテキスト</div></div>' + '\n' + '\n', '');
</script>
<?php
  }
}
add_action( 'admin_print_footer_scripts', 'appthemes_add_quicktags' );


// H1編集対応
function my_h1() {
	global $post;
	
	if (is_singular() && get_post_meta($post->ID, "myH1", true)) 
		echo get_post_meta($post->ID, "myH1", true);
	else
		echo get_bloginfo("description");
}

add_action('admin_menu', 'add_myH1');
add_action('save_post', 'save_myH1');

function add_myH1(){
 if(function_exists('add_myH1')){
  add_meta_box('myH1', 'myH1', 'insert_myH1', 'post', 'normal', 'high');
  add_meta_box('myH1', 'myH1', 'insert_myH1', 'page', 'normal', 'high');
 }
}

function insert_myH1(){
 global $post;
 wp_nonce_field(wp_create_nonce(__FILE__), 'my_nonce');
 echo '<label class="hidden" for="myH1">H1</label><input type="text" name="myH1" size="100" value="'.esc_html(get_post_meta($post->ID, 'myH1', true)).'" />';
 echo '<p>h1の文言を設定できます。省略時にはサイトのキャッチフレーズが表示されます。</p>';
}

function save_myH1($post_id){
 $my_nonce = isset($_POST['my_nonce']) ? $_POST['my_nonce'] : null;
 if(!wp_verify_nonce($my_nonce, wp_create_nonce(__FILE__))) {
  return $post_id;
 }
 if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) { return $post_id; }
 if(!current_user_can('edit_post', $post_id)) { return $post_id; }

 $data = $_POST['myH1'];

 if(get_post_meta($post_id, 'myH1') == ""){
  add_post_meta($post_id, 'myH1', $data, true);
 }elseif($data != get_post_meta($post_id, 'myH1', true)){
  update_post_meta($post_id, 'myH1', $data);
 }elseif($data == ""){
  delete_post_meta($post_id, 'myH1', get_post_meta($post_id, 'myH1', true));
 }
}

/* author 情報を非表示にする */
function disable_author_archive() {
  if( $_GET['author'] || preg_match('#/author/.+#', $_SERVER['REQUEST_URI']) ){
    wp_safe_redirect( home_url('/404.php') );
    exit;
  }
}
add_action('init', 'disable_author_archive');

/* REST APIでユーザー名を表示させない */
function my_filter_rest_endpoints( $endpoints ) {
    if ( isset( $endpoints['/wp/v2/users'] ) ) {
        unset( $endpoints['/wp/v2/users'] );
    }
    if ( isset( $endpoints['/wp/v2/users/(?P[\d]+)'] ) ) {
        unset( $endpoints['/wp/v2/users/(?P[\d]+)'] );
    }
    return $endpoints;
}
add_filter( 'rest_endpoints', 'my_filter_rest_endpoints', 10, 1 );

/* style.css にバージョン情報を追加 */
function my_update_styles( $styles ) {
  $mtime = filemtime( get_template_directory() . '/css/style.css' );
  $styles->default_version = $mtime;
}
add_action( 'wp_default_styles', 'my_update_styles' );

/* スタイルシート読み込み */
add_action( 'wp_enqueue_scripts', function(){
  // バージョン番号にcssファイルの更新日を指定
  wp_enqueue_style(
    'fcl-style',
    get_template_directory_uri() . '/css/style.css',
    array(),
    filemtime( get_template_directory() . '/css/style.css' )
  );
});
?>
